procedure stage2;
{Finds the trajectory of the ET for the Space Shuttle.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997}
var dtt,dFt,dRpt,m1n,Te1,dv,dv2,dv3,mp,mp1,mp2:double;
    cutoff:boolean;

begin{stage 2}
  write(question,'ET maximum angle of attack? ');
  readln(maxa);
  maxa := maxa*pi/180;

  Fd := MPS_N*(SSME_Fv-SSME_Fs);
  f0 := MPS_N*SSME_Fv*MPS_R2;
  Ar := pi*sqr(ET_D)/4 + ET_A + ORB_A;
  m1 := -f0/SSME_Vv;
  Me := ET_Ms + OMS_Mp + ORB_M + PL_M;
  dp := 0.0;
  dRp := 0.0;
  dF := 0.0;
  amax := amax1;
  traj := orb;
  iorb := true;
  pow := 2.0;
  dt := 1.0;  
  traj_acc;
  dt := 0.1;
  traj_acc;
  dt := 0.01;
  traj_acc;

  writeln('Maximum acceleration reached!');
  traj := air;
  fair := false;
  dtt := MPS_Tt3*SSME_I;
  dFt := -MPS_N*SSME_Fv/MPS_Tt3;
  dRpt := -dFt/SSME_Vv;
  m1n := -MPS_N*SSME_Fv*MPS_R3/SSME_Vv;
  cutoff := false;
  repeat
    dt := dtt;
    dF := dFt;
    dRp := dRpt;
    trajectory;
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    mp := -m1*Te;
    dv := SSME_Vv*ln(1 + mp/(m0 + Me - mp));
    Te1 := (m1n - m1)/dRpt;
    mp1 := -(m1n + m1)*Te1/2 - m1n*MPS_T3;
    dv3 := sqrt(via*via - vi*vi*sqr(sin(alpha))) - vi*cos(alpha);
    mp2 := (1 - exp(-dv3/SSME_Vv))*(m0 + Me) - mp1;
    dv2 := SSME_Vv*ln(1 + mp2/(m0 + Me - mp2));
    if dv2 < dv then
      begin{cutoff}
        Te := -mp2/m1;
        cutoff := true;
      end;{cutoff}
    time_traj;
  until cutoff = true;

  writeln('SSME throttle down to ',round(100*MPS_R3):2,'%');
  dF := dFt;
  dRp := dRpt;
  dt := 1.0;
  Te := Te1;
  time_traj;
  dF := 0.0;
  dRp := 0.0;
  dt := 1.0;
  repeat
    trajectory
  until vi > via;
  dt := -dt;
  trajectory;
  dt := 0.1;
  repeat
    trajectory
  until vi > via;
  dt := -dt;
  trajectory;
  dt := 0.01;
  repeat
    trajectory
  until vi > via;        

  writeln('Main Engine Cutoff (MECO)!');
  write('Perigee = ',(hp/1000):5:1,' km, ');
  write('Apogee = ',(ha/1000):5:1,' km, ');
  writeln('Average Altitude = ',(hp+ha)/2000:5:1,' km');
  f0 := 0.0;
  m1 := 0.0;
  Fd := 0.0;
  dF := 0.0;
  dRp := 0.0;
  dt := 1.0;
  Te := MPS_Ts;
  time_traj;

  writeln('ET separation!');
  write('Perigee = ',(hp/1000):5:1,' km, ');
  write('Apogee = ',(ha/1000):5:1,' km, ');
  writeln('Average Altitude = ',(hp+ha)/2000:5:1,' km');
  writeln('There is ',round(m0):1,' kg of propellant left.');
end;{stage 2}
